; Innosetup 5.2.3

[Setup]
AppName=Ant Movie Catalog Unofficial
AppVerName=Ant Movie Catalog Unofficial 4.0.0 [BETA]
AppCopyright=Copyright  2000-2011 Antoine Potten, Mickal Vanneufville
AppPublisher=Ant Software
AppPublisherURL=http://www.antp.be/software/
AppUpdatesURL=http://www.antp.be/software/moviecatalog/download/
AppVersion=4.0.0
AppId=Ant Movie Catalog Unofficial

DefaultDirName={pf}\Ant Movie Catalog Unofficial
DefaultGroupName=Ant Movie Catalog Unofficial

LicenseFile=license.txt
InfoBeforeFile=readme.txt

OutputBaseFilename=amcu_install
ChangesAssociations=true
UninstallDisplayName=Ant Movie Catalog Unofficial
AllowNoIcons=true

Compression=lzma
SolidCompression=yes

[Files]
Source: "MovieCatalog.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "AMCReport.exe"; DestDir: "{app}"; Flags: ignoreversion; Components: PrintTemplates
Source: "AMCExchange.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "MediaInfo.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "unicows.dll"; DestDir: "{app}"; Flags: ignoreversion; MinVersion: 4.0,0

Source: "default.xml"; DestDir: "{app}"; Flags: onlyifdoesntexist
Source: "Codecs.ini"; DestDir: "{app}"; Flags: onlyifdoesntexist
Source: "license.txt"; DestDir: "{app}"; Flags: ignoreversion

Source: "Toolbars\*.bmp"; DestDir: "{app}\Toolbars"; Flags: ignoreversion

Source: "Templates\*.gif"; DestDir: "{app}\Templates"; Flags: ignoreversion; Components: HtmlTemplates
Source: "Templates\*.jpg"; DestDir: "{app}\Templates"; Flags: ignoreversion; Components: HtmlTemplates
Source: "Templates\*.htm*"; DestDir: "{app}\Templates"; Flags: onlyifdoesntexist; Components: HtmlTemplates
Source: "Templates\*.txt"; DestDir: "{app}\Templates"; Flags: ignoreversion; Components: HtmlTemplates
Source: "Templates\*.zip"; DestDir: "{app}\Templates"; Flags: ignoreversion; Components: HtmlTemplates
Source: "Templates\*.frf"; DestDir: "{app}\Templates"; Flags: onlyifdoesntexist; Components: PrintTemplates

Source: "Catalogs\sample.amc"; DestDir: "{app}\Catalogs"

Source: "Languages\*.*"; Excludes: "English.*"; DestDir: "{app}\Languages"; Flags: ignoreversion; Components: Lang
Source: "Languages\English.*"; DestDir: "{app}\Languages"; Flags: ignoreversion
Source: "FRUSER.CNT"; DestDir: "{app}"; Flags: ignoreversion; Components: PrintTemplates
Source: "FRUSER.HLP"; DestDir: "{app}"; Flags: ignoreversion; Components: PrintTemplates

Source: "Scripts\*.*"; DestDir: "{app}\Scripts"; Flags: ignoreversion; Components: Scripts

[Registry]
Root: HKCR; Subkey: .amc; ValueType: string; ValueData: Ant Movie Catalog Unofficial; Flags: uninsdeletekey
Root: HKCR; Subkey: Ant Movie Catalog Unofficial; ValueType: string; ValueData: Ant Movie Catalog Unofficial; Flags: uninsdeletekey
Root: HKCR; Subkey: Ant Movie Catalog Unofficial\Shell\Open\Command; ValueType: string; ValueData: """{app}\moviecatalog.exe"" ""%1"""; Flags: uninsdeletevalue
Root: HKCR; Subkey: Ant Movie Catalog Unofficial\DefaultIcon; ValueType: string; ValueData: {app}\moviecatalog.exe,1; Flags: uninsdeletevalue

[Icons]
Name: "{group}\Ant Movie Catalog Unofficial"; Filename: "{app}\moviecatalog.exe"; WorkingDir: "{app}"
Name: "{group}\Report Designer"; Filename: "{app}\amcreport.exe"; WorkingDir: "{app}"; Flags: createonlyiffileexists
Name: "{group}\Uninstall Ant Movie Catalog Unofficial"; Filename: "{uninstallexe}"; WorkingDir: "{app}"

[InstallDelete]
Type: files; Name: "{app}\Toolbars\Classic.bmp"
Type: files; Name: "{app}\Toolbars\Kids.bmp"

[UninstallDelete]
Type: dirifempty; Name: "{app}\Catalogs"
Type: dirifempty; Name: "{app}\Templates"
Type: dirifempty; Name: "{app}\Languages"
Type: dirifempty; Name: "{app}\Scripts"
Type: dirifempty; Name: "{app}\Toolbars"
Type: files; Name: "{app}\prefs.xml"
Type: files; Name: "{app}\scripts.ini"
Type: files; Name: "{app}\AMCReport.ini"
Type: files; Name: "{app}\FRUSER.GID"
Type: dirifempty; Name: "{app}"

[Components]
Name: Lang; Description: Language files (translations); Types: custom full
Name: Scripts; Description: Scripts; Types: custom full
Name: PrintTemplates; Description: Printing templates & report designer; Types: custom full
Name: HtmlTemplates; Description: HTML export templates; Types: custom full

